<?php

namespace Modules\User\Enums;

use Modules\Support\Traits\EnumArrayable;

enum PermissionAction: string
{
    use EnumArrayable;

    case Index = "index";
    case Show = "show";
    case Create = "create";
    case Edit = "edit";
    case Destroy = "destroy";
    case markAsReceived = "mark_as_received";
    case Analytics = "analytics";
    case Viewer = "viewer";
    case Open = "open";
    case Close = "close";
    case Cancel = "cancel";
    case Refund = "refund";
    case Active = "active";
    case Upcoming = "upcoming";
    case ReceivePayment = "receive_payment";
    case UpdateStatus = "update_status";
    case AssignWaiter = "assign_waiter";
    case Merge = "merge";
    case Split = "split";
    case PrintReceipt = "print_receipt";
    case TotalSales = "total_sales";
    case TotalOrders = "total_orders";
    case TotalActiveOrders = "total_active_orders";
    case AverageOrderValue = "average_order_value";
    case TotalUsers = "total_users";
    case TotalMenus = "total_menus";
    case TotalProducts = "total_products";
    case TotalCategories = "total_categories";
    case SalesAnalytics = "sales_analytics";
    case  BestPerformingBranches = "best_performing_branches";
    case  OrderTypeDistribution = "order_type_distribution";
    case  OrderTotalByStatus = "order_total_by_status";
    case  PaymentsOverview = "payments_overview";
    case  BranchWiseSalesComparison = "branch_wise_sales_comparison";
    case  CashMovementsOverview = "cash_movements_overview";
    case  TopSellingProducts = "top_selling_products";
    case  LowStockAlerts = "low_stock_alerts";
    case  Sales = "sales";
    case ProductsPurchase = "products_purchase";
    case Tax = "tax";
    case BranchPerformance = "branch_performance";
    case Payments = "payments";
    case ProductTax = "product_tax";
    case IngredientUsage = "ingredient_usage";
    case RegisterSummary = "register_summary";
    case CashMovement = "cash_movement";
    case SalesByCreator = "sales_by_creator";
    case SalesByCashier = "sales_by_cashier";
    case Financials = "financials";
    case KitchenViewer = "kitchen_viewer";
    case CategorizedProducts = "categorized_products";
    case UpcomingOrders = "upcoming_orders";
    case CostAndRevenueByOrder = "cost_and_revenue_by_order";
    case CostAndRevenueByProduct = "cost_and_revenue_by_product";
    case IndexRewards = "index_rewards";
    case Redeem = "redeem";
    case AvailableGifts = "available_gifts";

}
