<?php

namespace Modules\Payment\Enums;

use Modules\Support\Traits\EnumArrayable;
use Modules\Support\Traits\EnumTranslatable;

enum PaymentType: string
{
    use EnumArrayable, EnumTranslatable;

    case Full = 'full';
    case Partial = 'partial';


    /** @inheritDoc */
    public static function toArrayTrans(): array
    {
        $cases = [];

        foreach (self::values() as $value) {
            $cases[] = [
                "id" => $value,
                "name" => __(PaymentType::getTransKey() . ".$value"),
                "icon" => PaymentType::getIcon($value),
                "color" => PaymentType::getColor($value),
            ];
        }

        return $cases;
    }

    /** @inheritDoc */
    public static function getTransKey(): string
    {
        return "payment::enums.payment_types";
    }

    /**
     * Get type icon by value
     *
     * @param string $value
     * @return string
     */
    public static function getIcon(string $value): string
    {
        return match ($value) {
            PaymentType::Full->value => 'tabler-circle-check',
            PaymentType::Partial->value => 'tabler-circle-half',
        };
    }

    /**
     * Get type color by value
     *
     * @param string $value
     * @return string
     */
    public static function getColor(string $value): string
    {
        return match ($value) {
            PaymentType::Full->value => '#0097e6',
            PaymentType::Partial->value => '#e1b12c',
        };
    }

    /**
     * Get enum as array value with trans
     *
     * @return array
     */
    public function toTrans(): array
    {
        return [
            "id" => $this->value,
            "name" => $this->trans(),
            "icon" => PaymentType::getIcon($this->value),
            "color" => PaymentType::getColor($this->value),
        ];
    }
}
