<?php

namespace Modules\Cart\Http\Controllers\Api\V1\Pos;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Cart\Facades\PosCart;
use Modules\Cart\Services\DiscountApplyService\DiscountApplyServiceInterface;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;

class CartVoucherController extends Controller
{
    /**
     * Apply voucher to cart
     *
     * @param Request $request
     * @param DiscountApplyServiceInterface $service
     * @return JsonResponse
     */
    public function store(Request $request, DiscountApplyServiceInterface $service): JsonResponse
    {
        $service->applyVoucher(PosCart::class, $request->input('code', ''));

        return ApiResponse::success(PosCart::instance());
    }
}
