<?php

namespace Modules\Branch\Http\Requests\Api\V1;

use Illuminate\Validation\Rule;
use Modules\Core\Http\Requests\Request;
use Modules\Currency\Currency;
use Modules\Order\Enums\OrderType;
use Modules\Payment\Enums\PaymentMethod;
use Modules\Support\Country;
use Modules\Support\TimeZone;


class SaveBranchRequest extends Request
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            ...$this->getTranslationRules(["name" => "required|string|max:255"]),
            "address" => "nullable|string|max:500",
            "registration_number" => "nullable|string|max:100",
            "phone" => "nullable|string|max:20",
            "email" => "nullable|email:rfc|max:50",
            "country_code" => ["required", Rule::in(Country::codes())],
            "timezone" => ["required", Rule::in(TimeZone::keys())],
            "currency" => ["required", Rule::in(Currency::codes())],
            "latitude" => "nullable|numeric|between:-90,90",
            "longitude" => "nullable|numeric|between:-180,180",
            "is_active" => "required|boolean",
            'order_types' => "required|array",
            "cash_difference_threshold" => "required|numeric|min:0|max:999999",
            "order_types.*" => ["required", Rule::in(OrderType::values())],
            'payment_methods' => "required|array",
            "payment_methods.*" => ["required", Rule::in(PaymentMethod::values())],
        ];
    }

    /** @inheritDoc */
    protected function availableAttributes(): string
    {
        return "branch::attributes.branches";
    }
}
