export const postRoutes = [
  {
    path: 'pos/viewer',
    name: 'admin.pos_viewer',
    meta: {
      title: 'pos::pos.pos_viewer',
      icon: 'tabler-cash-register',
      pageHeader: false,
      hiddenSidebar: true,
    },
    children: [
      {
        path: '',
        name: 'admin.pos.index',
        component: () => import('@/pages/Admin/Pos/Viewer/Index.vue'),
        meta: {
          permission: 'admin.pos.index',
        },
      },
    ],
  },
  {
    path: 'pos/kitchen-viewer',
    name: 'admin.pos_kitchen_viewer',
    meta: {
      title: 'pos::pos.kitchen_viewer',
      icon: 'tabler-chef-hat',
      pageHeader: false,
      hiddenSidebar: true,
    },
    children: [
      {
        path: '',
        name: 'admin.pos.kitchen_viewer',
        component: () => import('@/pages/Admin/Pos/KitchenViewer/Index.vue'),
        meta: {
          permission: 'admin.pos.kitchen_viewer',
        },
      },
    ],
  },
  {
    path: 'pos/registers',
    name: 'admin.pos_registers',
    meta: {
      title: 'pos::pos_registers.pos_registers',
      icon: 'tabler-device-desktop-cog',
    },
    children: [
      {
        path: '',
        name: 'admin.pos_registers.index',
        component: () => import('@/pages/Admin/Pos/Register/Index.vue'),
        meta: {
          permission: 'admin.pos_registers.index',
        },
      },
      {
        path: 'create',
        name: 'admin.pos_registers.create',
        component: () => import('@/pages/Admin/Pos/Register/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'pos::pos_registers.pos_register' },
          permission: 'admin.pos_registers.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.pos_registers.edit',
        component: () => import('@/pages/Admin/Pos/Register/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'pos::pos_registers.pos_register' },
          permission: 'admin.pos_registers.edit',
        },
      },
    ],
  },
  {
    path: 'pos/sessions',
    name: 'admin.pos_sessions',
    meta: {
      title: 'pos::pos_sessions.pos_sessions',
      icon: 'tabler-clock-dollar',
    },
    children: [
      {
        path: '',
        name: 'admin.pos_sessions.index',
        component: () => import('@/pages/Admin/Pos/Session/Index.vue'),
        meta: {
          permission: 'admin.pos_sessions.index',
        },
      },
      {
        path: ':id/cash-movements',
        name: 'admin.pos_sessions.pos_cash_movements.index',
        component: () => import('@/pages/Admin/Pos/CashMovement/Index.vue'),
        meta: {
          title: 'pos::pos_cash_movements.pos_cash_movements',
          permission: 'admin.pos_cash_movements.index',
          icon: 'tabler-cash',
        },
      },
    ],
  },
  {
    path: 'pos/cash-movements',
    name: 'admin.pos_cash_movements',
    meta: {
      title: 'pos::pos_cash_movements.pos_cash_movements',
      icon: 'tabler-cash',
    },
    children: [
      {
        path: '',
        name: 'admin.pos_cash_movements.index',
        component: () => import('@/pages/Admin/Pos/CashMovement/Index.vue'),
        meta: {
          permission: 'admin.pos_cash_movements.index',
        },
      },
    ],
  },
]
