import type { DropdownItem, LocalizedString } from '@/contracts'

export interface SupportedLanguagesState {
  id: string
  name: string
}

export interface AppSettingState {
  supported_locales: string[]
  supported_languages: SupportedLanguagesState[]
  locale: string
  fallback_locale: string
  is_rtl: boolean
  timezone: string
  currency: string
  app_name: string
}

export interface SettingsState {
  loading: boolean
}

export interface GeneralSettingsResponse {
  settings: GeneralSettings
  meta: GeneralSettingsMeta
}

export interface GeneralSettings {
  supported_countries: string[]
  default_country: string
  supported_locales: string[]
  default_locale: string
  default_timezone: string
  default_date_format: string
  default_time_format: string
  start_of_week: string
  end_of_week: string
}

export interface GeneralSettingsMeta {
  countries: DropdownItem[]
  locales: DropdownItem[]
  timezones: DropdownItem[]
  date_formats: DropdownItem[]
  time_formats: DropdownItem[]
  days: DropdownItem[]
}

export interface CurrencySettingsResponse {
  settings: CurrencySettings
  meta: CurrencySettingsMeta
}

export interface CurrencySettings {
  supported_currencies: string[]
  default_currency: ''
  currency_rate_exchange_service: string | null
  forge_api_key: string | null
  fixer_access_key: string | null
  currency_data_feed_api_key: string | null
  auto_refresh_currency_rates: boolean
  auto_refresh_currency_rate_frequency: string | null
}

export interface CurrencySettingsMeta {
  currencies: DropdownItem[]
  frequencies: DropdownItem[]
  exchange_services: DropdownItem[]
}

export interface ApplicationSettingsResponse {
  settings: ApplicationSettings
  meta: object
}

export interface ApplicationSettings {
  app_name: LocalizedString
}

export interface MailSettingsResponse {
  settings: MailSettings
  meta: MailSettingsMeta
}

export interface MailSettings {
  mail_mailer: string
  mail_from_address: string
  mail_from_name: string
  mail_host: string
  mail_port: string
  mail_username: | null
  mail_password: | null
  mail_encryption: | null
}

export interface MailSettingsMeta {
  mailers: DropdownItem[]
  encryption_protocols: DropdownItem[]
}

export interface FilesystemSettingsResponse {
  settings: FilesystemSettings
  meta: FilesystemSettingsMeta
}

export interface FilesystemSettings {
  default_filesystem_disk: string
  filesystem_s3_use_path_style_endpoint: boolean
  filesystem_s3_url: string | null
  filesystem_s3_endpoint: string | null
  filesystem_s3_region: string | null
  filesystem_s3_bucket: string | null
  encryptable: FilesystemSettingsEncryptable
}

interface FilesystemSettingsEncryptable {
  filesystem_s3_key: string | null
  filesystem_s3_secret: string | null
}

export interface FilesystemSettingsMeta {
  disks: DropdownItem[]
}
