import { api } from '@/api'

export function store (item: Record<string, any>) {
  return api.post(`/v1/orders`, item)
}

export function update (id: string | number, item: Record<string, any>) {
  return api.put(`/v1/orders/${id}`, item)
}

export function show (id: number | string) {
  return api.get(`/v1/orders/${id}/show`)
}

export function getFormEditMeta (id: number | string) {
  return api.get(`/v1/orders/${id}/meta/edit`)
}

export function cancel (id: number | string, item: Record<string, any>) {
  return api.post(`/v1/orders/${id}/cancel`, item)
}

export function refund (id: number | string, item: Record<string, any>) {
  return api.post(`/v1/orders/${id}/refund`, item)
}

export function getUpdateStatusMeta (id: number | string) {
  return api.get(`/v1/orders/${id}/update-status/meta`)
}

export function activeOrders () {
  return api.get(`/v1/orders/active`)
}

export function upcomingOrders () {
  return api.get(`/v1/orders/upcoming`)
}

export function addPayment (id: number | string, data: Record<string, any>, isMerge = false) {
  return api.post(`/v1/orders/${id}/add-payment${isMerge ? '-merge' : ''}`, data)
}

export function getAddPaymentMeta (id: number | string) {
  return api.get(`/v1/orders/${id}/add-payment/meta`)
}

export function moveToNextStatus (id: number | string) {
  return api.patch(`/v1/orders/${id}/move-to-next-status`)
}

export function getPrintReceipt (id: number | string) {
  return api.get(`/v1/orders/${id}/print`, { params: { roles: ['cashier'] } })
}
