import { api } from '@/api'

export function getRewards (customerId: number) {
  return api.get(`/v1/loyalty-gifts/rewards`, { params: { customer_id: customerId } })
}

export function redeem (customerId: number, rewardId: number, qty: number) {
  return api.post(`/v1/loyalty-gifts/rewards/${rewardId}/redeem`, { customer_id: customerId, qty })
}

export function getAvailable (customerId: number) {
  return api.get(`/v1/loyalty-gifts/available`, { params: { customer_id: customerId } })
}
