import { api } from '@/api'

export function storeItem (params: Record<string, any>) {
  return api.post('/v1/cart/edit-order/items', params)
}

export function updateItem (id: string, qty: number) {
  return api.put(`/v1/cart/edit-order/items/${id}`, { qty })
}

export function deleteItem (id: string) {
  return api.delete(`/v1/cart/edit-order/items/${id}`)
}

export function storeAction (id: string, action: string, qty: number) {
  return api.post(`/v1/cart/edit-order/items/${id}/action`, { action, qty })
}

export function removeAction (id: string, action: string) {
  return api.delete(`/v1/cart/edit-order/items/${id}/action`, { params: { action } })
}

export function applyDiscount (id: number) {
  return api.post(`/v1/cart/edit-order/discounts/${id}`)
}

export function removeDiscount () {
  return api.delete(`/v1/cart/edit-order/discounts`)
}

export function addCustomer (id: number) {
  return api.post(`/v1/cart/edit-order/customers/${id}`)
}

export function removeCustomer () {
  return api.delete(`/v1/cart/edit-order/customers`)
}

export function applyVoucher (code: string) {
  return api.post('/v1/cart/edit-order/vouchers', { code })
}

export function applyGift (id: number) {
  return api.post(`/v1/cart/edit-order/gifts/${id}`)
}
