<?php

namespace Modules\SeatingPlan\Http\Requests\Api\V1;

use Illuminate\Validation\Rule;
use Modules\Core\Http\Requests\Request;
use Modules\SeatingPlan\Enums\TableMergeType;
use Modules\SeatingPlan\Enums\TableStatus;

/**
 * @property-read int|null $floor_id
 * @property-read int|null $zone_id
 */
class TableMergeRequest extends Request
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $branch = auth()->user()->effective_branch;
        return [
            "table_ids" => "required|array",
            "table_ids.*" => [
                "bail",
                "required",
                "numeric",
                Rule::exists("tables", "id")
                    ->whereNull("deleted_at")
                    ->where('is_active', 1)
                    ->whereNotIn('status', [
                        TableStatus::Merged->value,
                        TableStatus::Cleaning->value,
                    ])
                    ->whereNull("current_merge_id")
                    ->whereNot('id', $this->route('id'))
                    ->where('branch_id', $branch->id),
            ],
            "type" => ["required", Rule::enum(TableMergeType::class)],
        ];
    }

    /** @inheritDoc */
    protected function availableAttributes(): string
    {
        return "seatingplan::attributes.table_merges";
    }
}
