<?php
return [
    "reports" => "Reports",
    "report" => "Report",

    "filters" => [
        "start_date" => "Start Date",
        "end_date" => "End Date",
        "order_status" => "Order Status",
        "order_type" => "Order Type",
        "payment_status" => "Payment Status",
        "product_name" => "Product Name",
        "payment_method" => "Payment Method",
        "reason" => "Reason",
        "direction" => "Direction",
        "menu" => "Menu",
    ],

    "groups" => [
        "restaurant_sales_reports" => "Restaurant Sales Reports",
        "inventory_reports" => "Inventory Reports",
        "pos_reports" => "POS Reports",
        "system_reports" => "System Reports",
    ],

    "definitions" => [
        "sales" => [
            "title" => "Sales Report",
            "description" => "A detailed breakdown of sales performance within a selected time range.",
        ],

        "products_purchase" => [
            "title" => "Products Purchase Report",
            "description" => "This report helps analyze product procurement performance across different periods"
        ],

        "tax" => [
            "title" => "Tax Report",
            "description" => "Summarizes collected taxes by order status, type, and payment over a selected period."
        ],

        "branch_performance" => [
            "title" => "Branch Performance Report",
            "description" => "Shows key sales and order metrics for each branch to compare performance over time."
        ],

        "payments" => [
            "title" => "Payments Report",
            "description" => "Breaks down received payments by method to track revenue collection."
        ],

        "product_tax" => [
            "title" => "Product Tax Report",
            "description" => "Displays the total tax amounts applied to specific products within a selected period."
        ],

        "ingredient_usage" => [
            "title" => "Ingredient Usage Report",
            "description" => "Tracks the total quantity of each ingredient used based on sold products during a selected period"
        ],

        "low_stock_alerts" => [
            "title" => "Low Stock Alerts",
            "description" => "Identifies ingredients that are nearing depletion or already finished to prompt timely restocking."
        ],

        "register_summary" => [
            "title" => "Register Summary Report",
            "description" => "Provides a financial summary of POS registers including sessions, sales, cash movements, and balances."
        ],

        "cash_movement" => [
            "title" => "Cash Movement Report",
            "description" => "Tracks all cash-in and cash-out transactions across POS registers, including users and reasons."
        ],

        "sales_by_creator" => [
            "title" => "Sales By Creator Report",
            "description" => "Shows total sales grouped by the user who created each order, helping track individual employee performance."
        ],

        "sales_by_cashier" => [
            "title" => "Sales By Cashier Report",
            "description" => "Summarizes total sales handled by each cashier, excluding canceled and refunded orders."
        ],

        "categorized_products" => [
            "title" => "Categorized Products Report",
            "description" => "Shows each category with its total product count — ideal for reviewing product distribution."
        ],
        "upcoming_orders" => [
            "title" => "Upcoming Orders Report",
            "description" => "Displays scheduled orders that are set to be prepared or served at a future time."
        ],

        "cost_and_revenue_by_order" => [
            "title" => "Cost & Revenue Report by Order",
            "description" => "Show each order’s total cost (based on product costs), total revenue (sales), and profit."
        ],

        "cost_and_revenue_by_product" => [
            "title" => "Cost & Revenue Report by Product",
            "description" => "Provides an overview of product performance in terms of quantity sold, cost, and revenue."
        ]
    ],
    "export_failed" => "Export failed. Please try again later."
];
