<?php

namespace Modules\Order\Transformers\Api\V1;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Order\Models\Order;

/** @mixin Order */
class EditOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "reference_no" => $this->reference_no,
            "order_number" => $this->order_number,
            "type" => $this->type->toTrans(),
            "due_amount" => $this->due_amount,
            "total" => $this->total,
            "refunded_amount" => $this->getRefundedAmount(),
            "table" => [
                "id" => $this->table_id,
                "name" => $this->relationLoaded("table") ? $this->table?->name : "",
            ],
            "pos_register_id" => $this->pos_register_id,
            "pos_session_id" => $this->pos_session_id,
            "currency" => $this->currency,
            "currency_rate" => $this->currency_rate,
            "guest_count" => $this->guest_count,
            "notes" => $this->notes,
            "details" => [
                "car_plate" => $this->car_plate,
                "car_description" => $this->car_description,
                "scheduled_at" => dateTimeFormat($this->scheduled_at),
            ],
        ];
    }
}
