<?php

namespace Modules\Order\Providers;

use Illuminate\Contracts\Support\DeferrableProvider;
use Illuminate\Support\ServiceProvider;
use Modules\Order\Services\CreateOrder\CreateOrderService;
use Modules\Order\Services\CreateOrder\CreateOrderServiceInterface;
use Modules\Order\Services\Order\OrderService;
use Modules\Order\Services\Order\OrderServiceInterface;
use Modules\Order\Services\Reason\ReasonService;
use Modules\Order\Services\Reason\ReasonServiceInterface;
use Modules\Order\Services\UpdateOrder\UpdateOrderService;
use Modules\Order\Services\UpdateOrder\UpdateOrderServiceInterface;

class DeferredOrderServiceProvider extends ServiceProvider implements DeferrableProvider
{
    /**
     * Boot the application events.
     */
    public function register(): void
    {
        $this->app->singleton(
            abstract: OrderServiceInterface::class,
            concrete: fn($app) => $app->make(OrderService::class)
        );

        $this->app->singleton(
            abstract: CreateOrderServiceInterface::class,
            concrete: fn($app) => $app->make(CreateOrderService::class)
        );

        $this->app->singleton(
            abstract: UpdateOrderServiceInterface::class,
            concrete: fn($app) => $app->make(UpdateOrderService::class)
        );

        $this->app->singleton(
            abstract: ReasonServiceInterface::class,
            concrete: fn($app) => $app->make(ReasonService::class)
        );

    }

    /**
     * Get the services provided by the provider.
     */
    public function provides(): array
    {
        return [
            OrderServiceInterface::class,
            CreateOrderServiceInterface::class,
            UpdateOrderServiceInterface::class,
            ReasonServiceInterface::class
        ];
    }
}
