<?php

namespace Modules\Cart\Http\Controllers\Api\V1\Pos;

use Darryldecode\Cart\Exceptions\InvalidConditionException;
use Illuminate\Http\JsonResponse;
use Modules\Cart\Facades\PosCart;
use Modules\Core\Http\Controllers\Controller;
use Modules\Order\Enums\OrderType;
use Modules\Support\ApiResponse;

class CartOrderTypeController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param OrderType $type
     * @return JsonResponse
     * @throws InvalidConditionException
     */
    public function store(OrderType $type): JsonResponse
    {
        PosCart::addOrderType($type);

        return ApiResponse::success(PosCart::instance());
    }

    /**
     * Destroy resource's.
     *
     * @return JsonResponse
     */
    public function destroy(): JsonResponse
    {
        PosCart::removeOrderType();

        return ApiResponse::success(PosCart::instance());
    }
}
