<?php

namespace Modules\Cart\Http\Controllers\Api\V1\EditOrder;

use Illuminate\Http\JsonResponse;
use Modules\Cart\Facades\EditOrderCart;
use Modules\Cart\Services\DiscountApplyService\DiscountApplyServiceInterface;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;

class CartDiscountController extends Controller
{
    /**
     * Apply discount to cart
     *
     * @param DiscountApplyServiceInterface $service
     * @param int $id
     * @return JsonResponse
     */
    public function store(DiscountApplyServiceInterface $service, int $id): JsonResponse
    {
        $service->applyDiscount(EditOrderCart::class, $id);

        return ApiResponse::success(EditOrderCart::instance());
    }


    /**
     * Remove discount from cart
     *
     * @return JsonResponse
     */
    public function destroy(): JsonResponse
    {
        EditOrderCart::removeDiscount();

        return ApiResponse::success(EditOrderCart::instance());
    }
}
