<?php

namespace Modules\Translation\Services\Translation;

use Modules\Translation\Models\Translation;
use Str;

class TranslationService implements TranslationServiceInterface
{
    /** @implements */
    public function label(): string
    {
        return __("translation::translations.translation");
    }

    /** @implements */
    public function update(string $key, string $locale, string $value): bool
    {
        return Translation::query()
            ->firstOrNew(['key' => $key])
            ->setTranslations('value', [$locale => $value])
            ->save();
    }

    public function getAppTranslations(): array
    {
        return Translation::appRetrieve();
    }

    /** @implements */
    public function retrieve(): array
    {
        return Translation::retrieve();
    }
}
