<?php

namespace Modules\Printer\Http\Requests\Api\V1;

use Illuminate\Validation\Rule;
use Modules\Core\Http\Requests\Request;
use Modules\Printer\Enum\PrinterConnectionType;
use Modules\Printer\Enum\PrinterRole;

class SavePrinterRequest extends Request
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            ...$this->getTranslationRules([
                "name" => "required|string|max:255",
            ]),
            ...$this->getBranchRule(),
            "role" => ["required", "string", Rule::enum(PrinterRole::class)],
            "connection_type" => ["required", "string", Rule::enum(PrinterConnectionType::class)],
            "category_slugs" => "nullable|array",
            "category_slugs.*" => "bail|required|string|exists:categories,slug,deleted_at,NULL,is_active,1",
            "is_active" => "required|boolean",
            "pos_register_id" => "bail|nullable|numeric|exists:pos_registers,id,deleted_at,NULL,is_active,1",
            'options.host' => 'required_if:connection_type,' . PrinterConnectionType::Tcp->value . '|ip',
            'options.port' => 'required_if:connection_type,' . PrinterConnectionType::Tcp->value . '|integer|min:1|max:65535',
        ];
    }

    /** @inheritDoc */
    protected function availableAttributes(): string
    {
        return "printer::attributes.printers";
    }
}
