<?php

namespace Modules\Cart\Facades;

use Darryldecode\Cart\CartCollection;
use Illuminate\Support\Facades\Facade;
use Modules\Cart\Cart;
use Modules\Cart\CartCurrentOrder;
use Modules\Cart\CartCustomer;
use Modules\Cart\CartOrderType;
use Modules\Discount\Models\Discount;
use Modules\Loyalty\Models\LoyaltyGift;
use Modules\Order\Enums\OrderType;
use Modules\Order\Models\Order;
use Modules\Order\Models\OrderProduct;
use Modules\User\Models\User;

/**
 * @method static Cart instance()
 * @method static void clear()
 * @method static void store(int $productId, int $qty, array $options = [], ?OrderProduct $orderProduct = null, ?LoyaltyGift $gift = null)
 * @method static void updateQuantity(string $id, int $qty)
 * @method static CartOrderType addOrderType(OrderType $type)
 * @method static void removeOrderType()
 * @method static CartCollection items()
 * @method static int addedQty(int $productId)
 * @method static bool remove(string $id)
 * @method static void initEditOrder(Order $order)
 * @method static void storeAction(string $id, string $action, int $quantity)
 * @method static void deleteAction(string $id, string $action)
 * @method static void applyDiscount(Discount $discount, ?LoyaltyGift $gift = null)
 * @method static void removeDiscount()
 * @method static CartCustomer addCustomer(User $customer)
 * @method static void removeCustomer()
 * @method static void addCurrentOrder(Order $order)
 * @method static CartCurrentOrder|null currentOrder():
 *
 * @see \Modules\Cart\EditOrderCart
 */
class EditOrderCart extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor(): string
    {
        return \Modules\Cart\EditOrderCart::class;
    }
}
