<?php

declare(strict_types=1);

/*
 * This file is part of Exchanger.
 *
 * (c) Florian Voutzinos <florian@voutzinos.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Exchanger\Contract;

/**
 * Contract for exchange rate services.
 *
 * @author Florian Voutzinos <florian@voutzinos.com>
 */
interface ExchangeRateService extends ExchangeRateProvider
{
    /**
     * Tells if the service supports the exchange rate query.
     *
     * @param ExchangeRateQuery $exchangeQuery
     *
     * @return bool
     */
    public function supportQuery(ExchangeRateQuery $exchangeQuery): bool;

    /**
     * Gets the name of the exchange rate service.
     *
     * @return string
     */
    public function getName(): string;
}
