<?php

namespace Modules\Order\Listeners;

use Modules\Order\Enums\OrderStatus;
use Modules\Order\Events\OrderUpdateStatus;
use Modules\Pos\Services\PosCashMovement\PosCashMovementServiceInterface;
use Throwable;

class OrderRefundAmount
{
    /**
     * Handle the event.
     *
     * @param OrderUpdateStatus $event
     *
     * @throws Throwable
     */
    public function handle(OrderUpdateStatus $event): void
    {
        if (
            in_array($event->status, [OrderStatus::Cancelled, OrderStatus::Refunded])
            && !$event->order->payment_status->isUnpaid()
            && !is_null($event->posSession)
        ) {
            app(PosCashMovementServiceInterface::class)
                ->refundCash(
                    session: $event->posSession,
                    amount: $event->order->getRefundedAmount()->amount(),
                    orderId: $event->order->id,
                    reference: $event->order->reference_no,
                    notes: $event->note
                );
        }
    }
}
