<?php

namespace Modules\Cart\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Cart\EditOrderCart;
use Modules\Cart\PosCart;
use Modules\Cart\Storages\CartDBStorage;

class CartServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     */
    public function register(): void
    {
        $this->app->singleton(PosCart::class, function ($app) {
            return new PosCart(
                new CartDBStorage(),
                $app['events'],
                'pos_cart',
                "pos_cart_" . auth()->id(),
                config("cart.cart")
            );
        });

        $this->app->alias(PosCart::class, 'pos_cart');

        $this->app->singleton(EditOrderCart::class, function ($app) {
            return new EditOrderCart(
                new CartDBStorage(),
                $app['events'],
                'edit_order_cart',
                "edit_order_cart_" . auth()->id(),
                config("cart.cart")
            );
        });

        $this->app->alias(EditOrderCart::class, 'edit_order_cart');


    }
}
