<?php

namespace Modules\Cart\Http\Controllers\Api\V1\Pos;

use Darryldecode\Cart\Exceptions\InvalidItemException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Cart\Facades\PosCart;
use Modules\Cart\Http\Requests\Api\V1\StoreCartItemRequest;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;

class CartItemController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param StoreCartItemRequest $request
     * @return JsonResponse
     * @throws InvalidItemException
     */
    public function store(StoreCartItemRequest $request): JsonResponse
    {
        PosCart::store(
            $request->product_id,
            $request->qty,
            $request->options ?? [],
        );

        return ApiResponse::success(PosCart::instance());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param string $id
     * @return JsonResponse
     */
    public function update(Request $request, string $id): JsonResponse
    {
        if (!isset(PosCart::get($id)['attributes']['loyalty_gift']['id'])) {
            PosCart::updateQuantity($id, $request->qty ?: 1);
        }

        return ApiResponse::success(PosCart::instance());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param string $id
     * @return JsonResponse
     */
    public function destroy(string $id): JsonResponse
    {
        PosCart::remove($id);

        return ApiResponse::success(PosCart::instance());
    }
}
