<?php

namespace Modules\Cart\Http\Controllers\Api\V1\Pos;

use Illuminate\Http\JsonResponse;
use Modules\Cart\Facades\PosCart;
use Modules\Cart\Services\DiscountApplyService\DiscountApplyServiceInterface;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;

class CartDiscountController extends Controller
{

    /**
     * Apply discount to cart
     *
     * @param DiscountApplyServiceInterface $service
     * @param int $id
     * @return JsonResponse
     */
    public function store(DiscountApplyServiceInterface $service, int $id): JsonResponse
    {
        $service->applyDiscount(PosCart::class, $id);

        return ApiResponse::success(PosCart::instance());
    }


    /**
     * Remove discount from cart
     *
     * @return JsonResponse
     */
    public function destroy(): JsonResponse
    {
        PosCart::removeDiscount();

        return ApiResponse::success(PosCart::instance());
    }
}
