import type { AppSettingState, AppState, SupportedLanguagesState } from '@/contracts'
import { defineStore } from 'pinia'

export const useAppStore = defineStore('app', {
  state: (): AppState => ({
    settings: {
      supported_locales: ['en'],
      supported_languages: [{
        id: 'en',
        name: 'English',
      }],
      locale: 'en',
      fallback_locale: 'en',
      timezone: 'Asia/Amman',
      currency: 'JOD',
      is_rtl: false,
      app_name: 'Forkiva',
    },
    translations: {},
    themeMode: 'light',
    currentLocale: 'en',
  }),
  getters: {
    supportedLocales: state => state.settings.supported_locales,
    supportedLanguages: state => state.settings.supported_languages,
    locale: state => state.settings.locale,
    appCurrentLocale: state => state.currentLocale,
    fallbackLocale: state => state.settings.fallback_locale,
    timezone: state => state.settings.timezone,
    currency: state => state.settings.currency,
    appName: state => state.settings.app_name,
    appTranslations: state => state.translations,
    appThemeMode: state => state.themeMode,
    currentLanguage: state => {
      return state.settings.supported_languages.find(lang => lang.id === state.currentLocale)
    },
    defaultLanguage: (state): SupportedLanguagesState => {
      return state.settings.supported_languages.find(lang => lang.id === state.settings.locale) as SupportedLanguagesState
    },
    isRtl: (state): boolean => state.settings.is_rtl,
  },
  actions: {
    restoreApp () {
      const mode = localStorage.getItem('theme_mode')
      this.themeMode = mode === 'dark' || mode === 'light' ? mode : 'light'
      this.currentLocale = localStorage.getItem('current_locale') || 'en'
    },
    setSettings (settings: AppSettingState) {
      this.settings = settings
      if (!settings.supported_locales.includes(this.currentLocale)) {
        this.setCurrentLocale(settings.locale)
      }
    },
    setTranslations (translations: object) {
      this.translations = translations
    },
    setThemeMode (mode: 'light' | 'dark') {
      this.themeMode = mode
      localStorage.setItem('theme_mode', mode)
    },
    setCurrentLocale (currentLocale: string) {
      this.currentLocale = currentLocale
      localStorage.setItem('current_locale', currentLocale)
    },
  },
})
