import type { SidebarItem } from '@/contracts/types/sidebar.ts'

export const sidebarItems: SidebarItem[] = [
  {
    key: 'admin.dashboard',
    label: 'admin::sidebar.dashboard',
    to: { name: 'admin.dashboard' },
    icon: 'tabler-layout-dashboard',
  },
  {
    key: 'admin.sales',
    label: 'admin::sidebar.sales',
    icon: 'tabler-basket-dollar',
    permission: [
      'admin.orders.index',
      'admin.payments.index',
      'admin.reasons.index',
    ],
    children: [
      {
        key: 'admin.orders.index',
        label: 'admin::sidebar.orders',
        to: { name: 'admin.orders.index' },
        permission: 'admin.orders.index',
      },
      {
        key: 'admin.payments.index',
        label: 'admin::sidebar.payments',
        to: { name: 'admin.payments.index' },
        permission: 'admin.payments.index',
      },
      {
        key: 'admin.reasons.index',
        label: 'admin::sidebar.reasons',
        to: { name: 'admin.reasons.index' },
        permission: 'admin.reasons.index',
      },
    ],
  },
  {
    key: 'admin.pos',
    label: 'admin::sidebar.pos',
    icon: 'tabler-cash',
    permission: [
      'admin.pos_registers.index',
      'admin.pos_sessions.index',
      'admin.pos_cash_movements.index',
    ],
    children: [
      {
        key: 'admin.pos_registers.index',
        label: 'admin::sidebar.pos_registers',
        to: { name: 'admin.pos_registers.index' },
        permission: 'admin.pos_registers.index',
      },
      {
        key: 'admin.pos_sessions.index',
        label: 'admin::sidebar.pos_sessions',
        to: { name: 'admin.pos_sessions.index' },
        permission: 'admin.pos_sessions.index',
      },
      {
        key: 'admin.pos_cash_movements.index',
        label: 'admin::sidebar.pos_cash_movements',
        to: { name: 'admin.pos_cash_movements.index' },
        permission: 'admin.pos_cash_movements.index',
      },
    ],
  },
  {
    key: 'admin.menus',
    label: 'admin::sidebar.menus',
    icon: 'tabler-list-details',
    permission: [
      'admin.menus.index',
      'admin.online_menus.index',
      'admin.categories.index',
      'admin.products.index',
      'admin.options.index',
    ],
    children: [
      {
        key: 'admin.menus.index',
        label: 'admin::sidebar.all_menus',
        to: { name: 'admin.menus.index' },
        permission: 'admin.menus.index',
      },
      {
        key: 'admin.online_menus.index',
        label: 'admin::sidebar.online_menus',
        to: { name: 'admin.online_menus.index' },
        permission: 'admin.online_menus.index',
      },
      {
        key: 'admin.categories.index',
        label: 'admin::sidebar.categories',
        to: { name: 'admin.categories.index' },
        permission: 'admin.categories.index',
      },
      {
        key: 'admin.products.index',
        label: 'admin::sidebar.products',
        to: { name: 'admin.products.index' },
        permission: 'admin.products.index',
      },
      {
        key: 'admin.options.index',
        label: 'admin::sidebar.options',
        to: { name: 'admin.options.index' },
        permission: 'admin.options.index',
      },
    ],
  },
  {
    key: 'admin.branches.index',
    label: 'admin::sidebar.branches',
    to: { name: 'admin.branches.index' },
    icon: 'tabler-git-branch',
    permission: 'admin.branches.index',
  },
  {
    key: 'admin.seating_plan',
    label: 'admin::sidebar.seating_plan',
    icon: 'tabler-building-skyscraper',
    permission: [
      'admin.tables.index',
      'admin.table_merges.index',
      'admin.zones.index',
      'admin.floors.index',
    ],
    children: [
      {
        key: 'admin.tables.index',
        label: 'admin::sidebar.tables',
        to: { name: 'admin.tables.index' },
        permission: 'admin.tables.index',
      },
      {
        key: 'admin.table_merges.index',
        label: 'admin::sidebar.table_merges',
        to: { name: 'admin.table_merges.index' },
        permission: 'admin.table_merges.index',
      },
      {
        key: 'admin.zones.index',
        label: 'admin::sidebar.zones',
        to: { name: 'admin.zones.index' },
        permission: 'admin.zones.index',
      },
      {
        key: 'admin.floors.index',
        label: 'admin::sidebar.floors',
        to: { name: 'admin.floors.index' },
        permission: 'admin.floors.index',
      },
    ],
  },
  {
    key: 'admin.inventory',
    label: 'admin::sidebar.inventory',
    icon: 'ic-outline-inventory-2',
    permission: [
      'admin.units.index',
      'admin.suppliers.index',
      'admin.ingredients.index',
      'admin.stock_movements.index',
      'admin.purchases.index',
      'admin.analytics.index',
    ],
    children: [
      {
        key: 'admin.inventories.analytics',
        label: 'admin::sidebar.analytics',
        to: { name: 'admin.inventories.analytics' },
        permission: 'admin.inventories.analytics',
      },
      {
        key: 'admin.units.index',
        label: 'admin::sidebar.units',
        to: { name: 'admin.units.index' },
        permission: 'admin.units.index',
      },
      {
        key: 'admin.suppliers.index',
        label: 'admin::sidebar.suppliers',
        to: { name: 'admin.suppliers.index' },
        permission: 'admin.suppliers.index',
      },
      {
        key: 'admin.ingredients.index',
        label: 'admin::sidebar.ingredients',
        to: { name: 'admin.ingredients.index' },
        permission: 'admin.ingredients.index',
      },
      {
        key: 'admin.stock_movements.index',
        label: 'admin::sidebar.stock_movements',
        to: { name: 'admin.stock_movements.index' },
        permission: 'admin.stock_movements.index',
      },
      {
        key: 'admin.purchases.index',
        label: 'admin::sidebar.purchases',
        to: { name: 'admin.purchases.index' },
        permission: 'admin.purchases.index',
      },
    ],
  },
  {
    key: 'admin.promotions',
    label: 'admin::sidebar.promotions',
    icon: 'tabler-target-arrow',
    permission: [
      'admin.discounts.index',
      'admin.vouchers.index',
    ],
    children: [
      {
        key: 'admin.discounts.index',
        label: 'admin::sidebar.discounts',
        to: { name: 'admin.discounts.index' },
        permission: 'admin.discounts.index',
      },
      {
        key: 'admin.vouchers.index',
        label: 'admin::sidebar.vouchers',
        to: { name: 'admin.vouchers.index' },
        permission: 'admin.vouchers.index',
      },
    ],
  },
  {
    key: 'admin.loyalty',
    label: 'admin::sidebar.loyalty',
    icon: 'tabler-gift',
    permission: [
      'admin.loyalty_programs.index',
      'admin.loyalty_tiers.index',
      'admin.loyalty_customers.index',
      'admin.loyalty_transactions.index',
      'admin.loyalty_rewards.index',
      'admin.loyalty_promotions.index',
      'admin.loyalty_gifts.index',
    ],
    children: [
      {
        key: 'admin.loyalty_programs.index',
        label: 'admin::sidebar.loyalty_programs',
        to: { name: 'admin.loyalty_programs.index' },
        permission: 'admin.loyalty_programs.index',
      },
      {
        key: 'admin.loyalty_tiers.index',
        label: 'admin::sidebar.loyalty_tiers',
        to: { name: 'admin.loyalty_tiers.index' },
        permission: 'admin.loyalty_tiers.index',
      },
      {
        key: 'admin.loyalty_rewards.index',
        label: 'admin::sidebar.loyalty_rewards',
        to: { name: 'admin.loyalty_rewards.index' },
        permission: 'admin.loyalty_rewards.index',
      },
      {
        key: 'admin.loyalty_promotions.index',
        label: 'admin::sidebar.loyalty_promotions',
        to: { name: 'admin.loyalty_promotions.index' },
        permission: 'admin.loyalty_promotions.index',
      },
      {
        key: 'admin.loyalty_customers.index',
        label: 'admin::sidebar.loyalty_customers',
        to: { name: 'admin.loyalty_customers.index' },
        permission: 'admin.loyalty_customers.index',
      },
      {
        key: 'admin.loyalty_gifts.index',
        label: 'admin::sidebar.loyalty_gifts',
        to: { name: 'admin.loyalty_gifts.index' },
        permission: 'admin.loyalty_gifts.index',
      },
      {
        key: 'admin.loyalty_transactions.index',
        label: 'admin::sidebar.loyalty_transactions',
        to: { name: 'admin.loyalty_transactions.index' },
        permission: 'admin.loyalty_transactions.index',
      },
    ],
  },
  {
    key: 'admin.media.index',
    label: 'admin::sidebar.media',
    to: { name: 'admin.media.index' },
    icon: 'tabler-photo-video',
    permission: 'admin.media.index',
  },
  {
    key: 'admin.printers.index',
    label: 'admin::sidebar.printers',
    to: { name: 'admin.printers.index' },
    icon: 'tabler-printer',
    permission: 'admin.printers.index',
  },
  {
    key: 'heading.system',
    label: 'admin::sidebar.system',
    isHeading: true,
    permission: [
      'admin.users.index',
      'admin.customers.index',
      'admin.roles.index',
      'admin.languages.index',
      'admin.activity_logs.index',
      'admin.authentication_logs.index',
      'admin.currency_rates.index',
      'admin.taxes.index',
      'admin.settings.index',
    ],
  },
  {
    key: 'admin.users_and_roles_management',
    label: 'admin::sidebar.users',
    icon: 'tabler-users-group',
    permission: [
      'admin.users.index',
      'admin.customers.index',
      'admin.roles.index',
    ],
    children: [
      {
        key: 'admin.users.index',
        label: 'admin::sidebar.users',
        to: { name: 'admin.users.index' },
        permission: 'admin.users.index',
      },
      {
        key: 'admin.customers.index',
        label: 'admin::sidebar.customers',
        to: { name: 'admin.customers.index' },
        permission: 'admin.customers.index',
      },
      {
        key: 'admin.roles.index',
        label: 'admin::sidebar.roles',
        to: { name: 'admin.roles.index' },
        permission: 'admin.roles.index',
      },
    ],
  },
  {
    key: 'admin.localization',
    label: 'admin::sidebar.localization',
    icon: 'tabler-world',
    permission: [
      'admin.languages.index',
      'admin.currency_rates.index',
      'admin.taxes.index',
    ],
    children: [
      {
        key: 'admin.translations.index',
        label: 'admin::sidebar.translations',
        to: { name: 'admin.translations.index' },
        permission: 'admin.translations.index',
      },
      {
        key: 'admin.currency_rates.index',
        label: 'admin::sidebar.currency_rates',
        to: { name: 'admin.currency_rates.index' },
        permission: 'admin.currency_rates.index',
      },
      {
        key: 'admin.taxes.index',
        label: 'admin::sidebar.taxes',
        to: { name: 'admin.taxes.index' },
        permission: 'admin.taxes.index',
      },
    ],
  },
  {
    key: 'admin.reports.index',
    label: 'admin::sidebar.reports',
    to: { name: 'admin.reports.index' },
    icon: 'tabler-chart-histogram',
    permission: 'admin.reports.index',
  },
  {
    key: 'admin.activities',
    label: 'admin::sidebar.activities',
    icon: 'tabler-history-toggle',
    permission: [
      'admin.activity_logs.index',
      'admin.authentication_logs.index',
    ],
    children: [
      {
        key: 'admin.activity_logs.index',
        label: 'admin::sidebar.activity_logs',
        to: { name: 'admin.activity_logs.index' },
        permission: 'admin.activity_logs.index',
      },
      {
        key: 'admin.authentication_logs.index',
        label: 'admin::sidebar.authentication_logs',
        to: { name: 'admin.authentication_logs.index' },
        permission: 'admin.authentication_logs.index',
      },
    ],
  },
  {
    key: 'admin.settings.edit',
    label: 'admin::sidebar.settings',
    to: { name: 'admin.settings.edit' },
    icon: 'tabler-settings',
    permission: 'admin.settings.edit',
  },
]
