import { guestMiddleware } from '@/middleware'

const prefix = 'auth'
export default [
  {
    path: `/${prefix}`,
    component: () => import('@/layouts/blank.vue'),
    beforeEnter: guestMiddleware,
    children: [
      {
        path: `/${prefix}/login`,
        component: () => import('@/pages/Auth/Login.vue'),
        name: 'auth.login',
        meta: { title: 'user::auth.login' },
      },
    ],
  },
]
