export const printerRoutes = [
  {
    path: 'printers',
    name: 'admin.printers',
    meta: {
      title: 'admin::sidebar.printers',
      icon: 'tabler-printer',
    },
    children: [
      {
        path: '',
        name: 'admin.printers.index',
        component: () => import('@/pages/Admin/Printer/Index.vue'),
        meta: {
          permission: 'admin.printers.index',
        },
      },
      {
        path: 'create',
        name: 'admin.printers.create',
        component: () => import('@/pages/Admin/Printer/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'printer::printers.printer' },
          permission: 'admin.printers.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.printers.edit',
        component: () => import('@/pages/Admin/Printer/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'printer::printers.printer' },
          permission: 'admin.printers.edit',
        },
      },
    ],
  },
]
