import type { ThemeDefinition } from 'vuetify'

export const staticPrimaryColor = '#F57C00'
export const staticPrimaryDarkenColor = '#EF6C00'
export const staticSecondaryColor = '#043A63' // 00695C
export const logoBase64 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIHdpZHRoPSc1MCcgaGVpZ2h0PSc1MCcgdmlld0JveD0nMCAwIDEwMjQgMTAyNCcgdmVyc2lvbj0nMS4xJz48cGF0aCBkPSdNIDI4Ni45NjMgMzQ2LjI1MCBDIDI0My45MDQgMzg4LjY2MCwgMjI2LjY1MSA0MTAuMzQwLCAyMTEuOTU3IDQ0MC41MDAgQyAxOTYuNjg4IDQ3MS44NDEsIDE5MCA1MDEuOTk0LCAxOTAgNTM5LjUwMCBDIDE5MCA1ODYuOTEyLCAyMDEuMzA4IDYyNi4xOTMsIDIyNS4yNjYgNjYyIEMgMjM4LjIyMCA2ODEuMzYwLCAyNDYuOTA4IDY5MC45NzcsIDI5My4wMjQgNzM3IEMgMzQ0Ljg3MSA3ODguNzQzLCAzNDkuMTE1IDc5Mi43MDcsIDM2Ny4xNDggODA2LjIzNyBDIDQxMS4zMDcgODM5LjM3MSwgNDUzLjAwNSA4NTcuMTA4LCA1MDQuNTAwIDg2NC42NjQgQyA1MTMuNjU0IDg2Ni4wMDcsIDUyMy4xNDAgODY2LjQzMywgNTQ0LjUwMCA4NjYuNDYyIEMgNTY5LjAwNyA4NjYuNDk1LCA1NzQuMzA5IDg2Ni4yMTIsIDU4NyA4NjQuMTkzIEMgNjQ4LjgwOCA4NTQuMzU3LCA2OTkuOTkwIDgyOC4yMzYsIDc0NC4wMTQgNzg0LjA2MCBDIDc3OC43ODMgNzQ5LjE3MCwgNzk4LjA4NiA3MTIuNzkwLCA4MDYuNjUzIDY2NiBDIDgwOS4xMzYgNjUyLjQzOSwgODA5LjE3MCA2MTMuNDE4LCA4MDYuNzExIDYwMCBDIDc5OC44NjYgNTU3LjE5NywgNzg0LjYzNiA1MjguNDE1LCA3NTQuODAxIDQ5NSBDIDc0My42NzEgNDgyLjUzNCwgNzIyLjc5NSA0NjMuMTM1LCA3MjIuMjUxIDQ2NC43NTQgQyA3MjIuMDIwIDQ2NS40NDQsIDcxNy43NDkgNDcyLjE5NCwgNzEyLjc2MCA0NzkuNzU0IEMgNzA0LjA5NCA0OTIuODg2LCA3MDIuMDM0IDQ5NS4xNjQsIDY2Ni42NDggNTMwLjc1MCBDIDY0MC4yNjYgNTU3LjI4MSwgNjMwLjIwNiA1NjgsIDYzMS42ODggNTY4IEMgNjMyLjgzMiA1NjgsIDYzNy41MjYgNTY5Ljg4MSwgNjQyLjExOSA1NzIuMTc5IEMgNjQ4LjU5OSA1NzUuNDIzLCA2NTIuMzk4IDU3OC4yNzcsIDY1OS4wODUgNTg0LjkyOSBDIDY3NC4wMDMgNTk5Ljc2OCwgNjgwLjIzOCA2MTQuNDQ3LCA2ODAuMzUzIDYzNSBDIDY4MC40MjIgNjQ3LjQ0OCwgNjc4LjQ2OSA2NTYuMTQzLCA2NzMuMjgzIDY2Ni40NzUgQyA2NjMuNzM5IDY4NS40OTAsIDY0NC42NzkgNzAxLjk5MywgNjI0LjUwMCA3MDguNzE1IEMgNjE3LjM1NSA3MTEuMDk1LCA2MTQuOTUxIDcxMS4zODYsIDYwMiA3MTEuNDM1IEMgNTg2LjA0MiA3MTEuNDk2LCA1NzkuNDc0IDcxMC4yNTEsIDU2OC4zMjIgNzA1LjA1MyBDIDU1Ny42NDIgNzAwLjA3NCwgNTUxLjE2OSA2OTQuODY5LCA1MjYuNTAwIDY3MS40MjIgQyA0OTMuNDE5IDYzOS45ODAsIDMyNy40NjYgNDcyLjk1OSwgMzI3LjY0NSA0NzEuMjg3IEMgMzI3Ljc1NiA0NzAuMjQwLCAzMjcuNDcyIDQ3MC4xOTQsIDMyNi40MDEgNDcxLjA4MiBDIDMyNS4yODkgNDcyLjAwNSwgMzIzLjQxNSA0NzAuNjgxLCAzMTcuMDIxIDQ2NC40NTkgQyAyOTkuMTc3IDQ0Ny4wOTMsIDI4OS4wOTkgNDI2LjMxMywgMjg1Ljk4NCA0MDAuNDU0IEMgMjgzLjI2MCAzNzcuODUwLCAyODguOTU1IDM1MS41NTMsIDMwMC4wNzQgMzM1LjM5MiBDIDMwMS43MzYgMzMyLjk3NywgMzAyLjk1MCAzMzEsIDMwMi43NzEgMzMxIEMgMzAyLjU5MyAzMzEsIDI5NS40NzkgMzM3Ljg2MywgMjg2Ljk2MyAzNDYuMjUwJyBzdHJva2U9J25vbmUnIGZpbGw9JyMwNDNhNjMnIGZpbGwtcnVsZT0nZXZlbm9kZCcvPjxwYXRoIGQ9J00gNTE4IDE3Ny4wODcgQyA0NzMuNTc2IDE4Mi43ODAsIDQzNC4xMTYgMjAxLjQzNCwgMzk4LjYxMCAyMzMuNTI2IEMgMzgxLjA4MyAyNDkuMzY3LCAzMDYuMDEwIDMyNi41MDcsIDMwMS4zMjggMzMzLjQ4NiBDIDI3OS4zNjcgMzY2LjIyMiwgMjgwLjEwNSA0MTQuMDc2LCAzMDMuMDk3IDQ0OC4xOTEgQyAzMDcuNDc5IDQ1NC42OTMsIDMyMS4wODggNDY5LjQyMCwgMzI0LjMyOSA0NzEuMTY5IEMgMzI1Ljg5NyA0NzIuMDE0LCAzMzcuNTQxIDQ2MC44MDksIDQwNS44MjkgMzkyLjc0MCBDIDQ1My40ODkgMzQ1LjIzMywgNDg4LjExMiAzMTEuNDk5LCA0OTIgMzA4Ljc4MiBDIDUwMC43NDEgMzAyLjY3MywgNTA3LjE4MyAyOTkuNTQ4LCA1MTcuNjkzIDI5Ni4zMTggQyA1MjUuNjA1IDI5My44ODYsIDUyNy45NzQgMjkzLjYxNywgNTQxIDI5My42NzEgQyA1NTguMDI4IDI5My43NDIsIDU2Ni4zODkgMjk1LjU2OCwgNTc5LjMyMSAzMDIuMDQxIEMgNTg5LjQyNiAzMDcuMDk4LCA1OTYuMjQxIDMxMi4zMDMsIDYwNC42NDQgMzIxLjM3OCBDIDYxOS4yNjcgMzM3LjE3MywgNjI1Ljk0NiAzNTQuNjA5LCA2MjUuOTgzIDM3Ny4wOTAgQyA2MjYuMDExIDM5NC4xMDAsIDYyMS42ODggNDA4LjE1OSwgNjExLjc4OSA0MjMuMjUwIEMgNjA2LjQ4NyA0MzEuMzMzLCA1OTUuNjI5IDQ0Mi41OTcsIDUyNS43NTcgNTEyLjUwMCBMIDQ0NS43OTIgNTkyLjUwMCA0ODAuNjI2IDYyNi44NjkgQyA0OTkuNzg0IDY0NS43NzIsIDUxNy44NDMgNjYzLjI3NCwgNTIwLjc1NyA2NjUuNzYzIEwgNTI2LjA1NCA2NzAuMjg5IDU1NS43NzcgNjQwLjk3NSBDIDU3Mi4xMjUgNjI0Ljg1MywgNjEyLjEwMyA1ODUuMDc1LCA2NDQuNjE3IDU1Mi41ODEgQyA3MDMuNzIxIDQ5My41MTQsIDcwMy43MzcgNDkzLjQ5NywgNzEyLjk1OSA0NzkuNTAwIEMgNzI0LjE0NCA0NjIuNTI1LCA3MjkuNzA0IDQ1MS4zNDEsIDczNC44MzEgNDM1LjUwMCBDIDc0Mi4yOTIgNDEyLjQ0OSwgNzQzLjUwNyA0MDMuOTIwLCA3NDMuNDQ5IDM3NSBDIDc0My40MDIgMzUxLjI1MCwgNzQzLjIxNCAzNDguNjMyLCA3NDAuNzE1IDMzNi44NTQgQyA3MzQuMjMwIDMwNi4zMDMsIDcyMy4yNTMgMjgxLjk3OSwgNzA0LjkwMiAyNTcuNTAwIEMgNjcyLjUxNyAyMTQuMjk5LCA2MjMuMzQ2IDE4NS42MDksIDU2Ny44NzIgMTc3LjU0NSBDIDU1Ni40NTQgMTc1Ljg4NSwgNTI5LjMyMCAxNzUuNjM2LCA1MTggMTc3LjA4Nycgc3Ryb2tlPSdub25lJyBmaWxsPScjZmI5NDExJyBmaWxsLXJ1bGU9J2V2ZW5vZGQnLz48L3N2Zz4='
export const themes: Record<string, ThemeDefinition> = {
  light: {
    dark: false,
    colors: {
      'primary': staticPrimaryColor,
      'on-primary': '#fff',
      'primary-darken-1': staticPrimaryDarkenColor,
      'primary-light': '#8789FF',
      'secondary': staticSecondaryColor,
      'on-secondary': '#fff',
      'secondary-darken-1': staticSecondaryColor,
      'secondary-light': staticSecondaryColor,
      'success': '#2ecc71',
      'on-success': '#fff',
      'success-darken-1': '#66C732',
      'success-light': '#53D28C',
      'info': '#03C3EC',
      'on-info': '#fff',
      'info-darken-1': '#03AFD4',
      'info-light': '#35CFF0',
      'warning': '#f1c40f',
      'on-warning': '#fff',
      'warning-darken-1': '#E69A00',
      'warning-light': '#FFBC33',
      'error': '#e74c3c',
      'on-error': '#fff',
      'error-darken-1': '#E6381A',
      'error-light': '#FF654A',
      'background': '#f5f5f9',
      'on-background': '#22303E',
      'surface': '#fff',
      'on-surface': '#22303E',
      'grey-50': '#FAFAFA',
      'grey-100': '#F5F5F5',
      'grey-200': '#EEEEEE',
      'grey-300': '#E0E0E0',
      'grey-400': '#BDBDBD',
      'grey-500': '#9E9E9E',
      'grey-600': '#757575',
      'grey-700': '#616161',
      'grey-800': '#424242',
      'grey-900': '#212121',
      'grey-light': '#FAFAFA',
      'perfect-scrollbar-thumb': '#DBDADE',
      'skin-bordered-background': '#fff',
      'skin-bordered-surface': '#fff',
      'expansion-panel-text-custom-bg': '#fafafa',
    },

    variables: {
      'code-color': '#d400ff',
      'overlay-scrim-background': '#22303E',
      'tooltip-background': '#22303E',
      'overlay-scrim-opacity': 0.5,
      'hover-opacity': 0.06,
      'focus-opacity': 0.1,
      'selected-opacity': 0.08,
      'activated-opacity': 0.16,
      'pressed-opacity': 0.14,
      'dragged-opacity': 0.1,
      'disabled-opacity': 0.4,
      'border-color': '#22303E',
      'border-opacity': 0.12,
      'table-header-color': '#FFFFFF',
      'high-emphasis-opacity': 0.9,
      'medium-emphasis-opacity': 0.7,
      'switch-opacity': 0.2,
      'switch-disabled-track-opacity': 0.3,
      'switch-disabled-thumb-opacity': 0.4,
      'switch-checked-disabled-opacity': 0.3,
      'track-bg': '#EEF1F3',
      'chat-bg': '#F7F8F8',
      // Shadows
      'shadow-key-umbra-color': '#22303E',
      'shadow-xs-opacity': 0.06,
      'shadow-sm-opacity': 0.06,
      'shadow-md-opacity': 0.06,
      'shadow-lg-opacity': 0.06,
      'shadow-xl-opacity': 0.06,
      'table-head-bg': '#fafafa',
      'on-table-head-bg': '#333333',
    },
  },
  dark: {
    dark: true,
    colors: {
      'primary': staticPrimaryColor,
      'on-primary': '#fff',
      'primary-darken-1': staticPrimaryDarkenColor,
      'primary-light': '#8789FF',
      'secondary': staticSecondaryColor,
      'on-secondary': '#fff',
      'secondary-darken-1': staticSecondaryColor,
      'secondary-light': staticSecondaryColor,
      'success': '#71DD37',
      'on-success': '#fff',
      'success-darken-1': '#66C732',
      'success-light': '#53D28C',
      'info': '#03C3EC',
      'on-info': '#fff',
      'info-darken-1': '#03AFD4',
      'info-light': '#35CFF0',
      'warning': '#FFAB00',
      'on-warning': '#fff',
      'warning-darken-1': '#E69A00',
      'warning-light': '#FFBC33',
      'error': '#FF3E1D',
      'on-error': '#fff',
      'error-darken-1': '#E6381A',
      'error-light': '#FF654A',
      'background': '#232333',
      'on-background': '#E6E6F1',
      'surface': '#2B2C40',
      'on-surface': '#E6E6F1',
      'grey-50': '#26293A',
      'grey-100': '#2F3349',
      'grey-200': '#26293A',
      'grey-300': '#4A5072',
      'grey-400': '#5E6692',
      'grey-500': '#7983BB',
      'grey-600': '#AAB3DE',
      'grey-700': '#B6BEE3',
      'grey-800': '#CFD3EC',
      'grey-900': '#E7E9F6',
      'grey-light': '#313246',
      'perfect-scrollbar-thumb': '#4A5072',
      'skin-bordered-background': '#2B2C40',
      'skin-bordered-surface': '#2B2C40',
    },
    variables: {
      'code-color': '#d400ff',
      'overlay-scrim-background': '#1D1D2A',
      'tooltip-background': '#E6E6F1',
      'overlay-scrim-opacity': 0.6,
      'hover-opacity': 0.06,
      'focus-opacity': 0.1,
      'selected-opacity': 0.08,
      'activated-opacity': 0.16,
      'pressed-opacity': 0.14,
      'dragged-opacity': 0.1,
      'disabled-opacity': 0.4,
      'border-color': '#E6E6F1',
      'border-opacity': 0.12,
      'table-header-color': '#2B2C40',
      'high-emphasis-opacity': 0.9,
      'medium-emphasis-opacity': 0.7,
      'switch-opacity': 0.4,
      'switch-disabled-track-opacity': 0.4,
      'switch-disabled-thumb-opacity': 0.8,
      'switch-checked-disabled-opacity': 0.3,
      'track-bg': '#41415F',
      'chat-bg': '#20202E',

      // Shadows
      'shadow-key-umbra-color': '#14141D',
      'shadow-xs-opacity': 0.18,
      'shadow-sm-opacity': 0.2,
      'shadow-md-opacity': 0.22,
      'shadow-lg-opacity': 0.24,
      'shadow-xl-opacity': 0.26,

      'table-head-bg': '#1e1e1e',
      'on-table-head-bg': '#eeeeee',
    },
  },
}

export default themes
