import { type RouteLocationRaw, useRouter } from 'vue-router'
import { useToast } from 'vue-toastification'
import * as authApi from '@/api/user/auth.ts'
import { useAuthStore } from '@/stores'

export function useAuth () {
  const authStore = useAuthStore()
  const router = useRouter()

  const login = async (identifier: string, password: string) => {
    const response = await authApi.login(identifier, password)
    authStore.setAuth(response.data.body)
    let name = 'admin.dashboard'
    if ((authStore.hasRole('cashier') || authStore.hasRole('waiter')) && authStore.can('admin.pos.index')) {
      name = 'admin.pos.index'
    } else if (authStore.hasRole('kitchen') && authStore.can('admin.pos.kitchen_viewer')) {
      name = 'admin.pos.kitchen_viewer'
    }

    await router.push({ name } as unknown as RouteLocationRaw)
  }

  const logout = async () => {
    try {
      useToast().success((await authApi.logout()).data.message)
    } catch {
      /* empty */
    }
    authStore.logout()
    await router.push({ name: 'auth.login' } as unknown as RouteLocationRaw)
  }

  const check = async () => {
    try {
      await authApi.check()
      return true
    } catch {
      return false
    }
  }

  return {
    store: authStore,
    user: authStore.getUser,
    login,
    logout,
    check,
    can: authStore.can,
    canAny: authStore.canAny,
    hasPermission: authStore.hasPermission,
    hasRole: authStore.hasRole,
    hasAnyRoles: authStore.hasAnyRoles,
  }
}
