import type { AxiosError } from 'axios'
import { useI18n } from 'vue-i18n'
import { useToast } from 'vue-toastification'
import * as currencyRate from '@/api/currency/currencyRate.ts'

export function useCurrencyRate () {
  const toast = useToast()
  const { t } = useI18n()

  const refresh = async () => {
    try {
      const response = await currencyRate.refresh()
      toast.success(response.data.message)
    } catch (error) {
      toast.error((error as AxiosError<{
        message?: string
      }>).response?.data?.message || t('core::errors.an_unexpected_error_occurred'))
    }
  }

  const getCurrencyRate = async (id: number) => {
    try {
      return await currencyRate.getCurrencyRate(id)
    } catch {
      // TODO: 404: rEDIRECT 404 else show erorr message
    }
    return false
  }

  return { refresh, getCurrencyRate, updateCurrencyRate: currencyRate.updateCurrencyRate }
}
