import { api } from '@/api'

export const overview = () => api.get(`/v1/dashboards/overview`)
export const salesAnalytics = (filter: string) => api.get(`/v1/dashboards/sales-analytics/${filter}`)
export const bestPerformingBranches = (filter: string) => api.get(`/v1/dashboards/best-performing-branches/${filter}`)
export const orderTypeDistribution = (filter: string) => api.get(`/v1/dashboards/order-type-distribution/${filter}`)
export const orderTotalByStatus = (filter: string) => api.get(`/v1/dashboards/order-total-by-status/${filter}`)
export const paymentsOverview = (filter: string) => api.get(`/v1/dashboards/payments-overview/${filter}`)

export const hourlySalesTrend = () => api.get('/v1/dashboards/hourly-sales-trend')
export const branchWiseSalesComparison = (filter: string) => api.get(`/v1/dashboards/branch-wise-sales-comparison/${filter}`)
export const cashMovementsOverview = (filter: string) => api.get(`/v1/dashboards/cash-movements-overview/${filter}`)
export const topSellingProducts = (filter: string) => api.get(`/v1/dashboards/top-selling-products/${filter}`)
export const lowStockAlerts = () => api.get(`/v1/dashboards/low-stock-alerts`)
