import { createVNode as _createVNode, createElementVNode as _createElementVNode } from "vue";
// Styles
import "./VCalendarHeader.css";

// Components
import { VBtn } from "../../components/VBtn/index.js"; // Composables
import { useLocale } from "../../composables/locale.js"; // Utilities
import { genericComponent, propsFactory, useRender } from "../../util/index.js"; // Types
export const makeVCalendarHeaderProps = propsFactory({
  nextIcon: {
    type: String,
    default: '$next'
  },
  prevIcon: {
    type: String,
    default: '$prev'
  },
  title: String,
  text: {
    type: String,
    default: '$vuetify.calendar.today'
  },
  viewMode: {
    type: String,
    default: 'month'
  }
}, 'VCalendarHeader');
export const VCalendarHeader = genericComponent()({
  name: 'VCalendarHeader',
  props: makeVCalendarHeaderProps(),
  emits: {
    'click:next': () => true,
    'click:prev': () => true,
    'click:toToday': () => true
  },
  setup(props, _ref) {
    let {
      emit,
      slots
    } = _ref;
    const {
      t
    } = useLocale();
    function prev() {
      emit('click:prev');
    }
    function next() {
      emit('click:next');
    }
    function toToday() {
      emit('click:toToday');
    }
    useRender(() => _createElementVNode("div", {
      "class": "v-calendar-header"
    }, [props.text && _createVNode(VBtn, {
      "key": "today",
      "class": "v-calendar-header__today",
      "text": t(props.text),
      "variant": "outlined",
      "onClick": toToday
    }, null), _createVNode(VBtn, {
      "density": "comfortable",
      "icon": props.prevIcon,
      "variant": "text",
      "onClick": prev
    }, null), _createVNode(VBtn, {
      "density": "comfortable",
      "icon": props.nextIcon,
      "variant": "text",
      "onClick": next
    }, null), _createElementVNode("div", {
      "class": "v-calendar-header__title"
    }, [slots.title?.({
      title: props.title
    }) ?? _createElementVNode("span", null, [props.title])])]));
    return {};
  }
});
//# sourceMappingURL=VCalendarHeader.js.map