<?php

namespace Modules\Setting\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\Setting\Models\Setting;

class SettingDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Setting::setMany([
            "supported_countries" => ['JO'],
            'default_country' => 'JO',
            'supported_currencies' => ["JOD"],
            'default_currency' => 'JOD',
            'supported_locales' => ['en', 'ar'],
            'default_locale' => 'en',
            'default_timezone' => 'Asia/Amman',
            'translatable' => [
                'app_name' => 'Forkiva',
            ],
            "encryptable" => [
            ],
            'default_date_format' => 'Y-m-d',
            'default_time_format' => 'h:i A',
            'start_of_week' => "sunday",
            'end_of_week' => "saturday",
            'default_filesystem_disk' => 'public',
        ]);
    }
}
