<?php

namespace Modules\Printer\Services\Printer;

use Exception;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Collection;
use LogicException;
use Modules\Printer\Enum\PrinterConnectionType;
use Modules\Printer\Enum\PrinterRole;
use Modules\Printer\Models\Printer;

interface PrinterServiceInterface
{
    /**
     * Label for the resource.
     *
     * @return string
     */
    public function label(): string;

    /**
     * Model for the resource.
     *
     * @return string
     */
    public function model(): string;

    /**
     * Get a new instance of the model.
     *
     * @return Printer
     */
    public function getModel(): Printer;

    /**
     * Get specific resource
     *
     * @param int $id
     * @return Printer|Builder|EloquentCollection|array;
     * @throws ModelNotFoundException
     */
    public function findOrFail(int $id): Printer|Builder|EloquentCollection|array;

    /**
     * Display a listing of the resource.
     *
     * @param array $filters
     * @param array $sorts
     * @return LengthAwarePaginator
     */
    public function get(array $filters = [], array $sorts = []): LengthAwarePaginator;

    /**
     * Show the specified resource.
     *
     * @param int $id
     * @return Printer
     * @throws ModelNotFoundException
     */
    public function show(int $id): Printer;

    /**
     * Store a newly created resource in storage.
     *
     * @param array $data
     * @return Printer
     */
    public function store(array $data): Printer;

    /**
     * Update the specified resource in storage.
     *
     * @param int $id
     * @param array $data
     * @return Printer
     * @throws ModelNotFoundException
     */
    public function update(int $id, array $data): Printer;

    /**
     * Destroy resource's by given id.
     *
     * @param int|array|string $ids
     * @return bool
     * @throws ModelNotFoundException
     * @throws LogicException
     */
    public function destroy(int|array|string $ids): bool;

    /**
     * Get structure filters for frontend
     *
     * @return array
     */
    public function getStructureFilters(): array;

    /**
     * Get form meta
     *
     * @param int|null $branchId
     * @return array
     */
    public function getFormMeta(?int $branchId = null): array;

    /**
     * Get available printers for
     *
     * @param PrinterRole $role
     * @param int $branchId
     * @param PrinterConnectionType|null $connectionType
     * @return Collection
     */
    public function for(PrinterRole $role, int $branchId, ?PrinterConnectionType $connectionType = null): Collection;

    /**
     * Print dispatch
     *
     * @param PrinterRole $role
     * @param array $data
     * @param PrinterConnectionType|null $connectionType
     * @return void
     * @throws Exception
     */
    public function dispatch(PrinterRole $role, array $data, ?PrinterConnectionType $connectionType = null): void;
}
