<?php

namespace Modules\Order\Listeners;

use Modules\Inventory\Services\StockSync\StockSyncServiceInterface;
use Modules\Order\Enums\OrderStatus;
use Modules\Order\Events\OrderUpdateStatus;
use Throwable;

class RestoreOrderStock
{
    /**
     * Handle the event.
     */
    public function handle(OrderUpdateStatus $event): void
    {
        if (
            in_array($event->status, [OrderStatus::Refunded, OrderStatus::Cancelled])
            && $event->order->is_stock_deducted
        ) {
            try {
                app(StockSyncServiceInterface::class)->restoreOrderStock($event->order);
                $event->order->update(["is_stock_deducted" => false]);
            } catch (Throwable) {
            }
        }
    }
}
